<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/AnomaliesCCA"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="AnomaliesCCA"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word">
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/BudgetCCA[(./Anomalie) and (./@IdNat=$docbudg/EnteteComptable/Infos/Collectivite/@IdNat)]/Anomalie"/><thead>
               <tr><td width="73%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/>
                        
                        
                     </p></td><td width="27%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr>
               <tr><td width="73%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="27%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@PlanCpte)"/></span></p></td></tr>
               <tr><td width="73%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="27%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Population : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/EnteteComptable/Infos/Collectivite/@Population"/><xsl:with-param name="format" select="&quot;# ##0&quot;"/></xsl:call-template></span></p></td></tr>
               <tr><td width="73%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="27%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Type de budget : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeBC)"/></span></p></td></tr>
               <tr><td width="73%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="27%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Type de collectivité : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeColl)"/></span></p></td></tr>
               <tr><td width="73%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="27%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Édition : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@TypeEdition)"/></span></p></td></tr>
               <tr><td width="100%" colspan="3" valign="top" style="border:none; border-bottom:solid black 1.0pt;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></b></p><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">État d’anomalies des contrôles comptables</span></b></p><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">Arrêté à la date du : <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p><p align="right" style="text-align:right"> </p></td></tr>
               <tr style="height:7.15pt"><td width="7%" style="border:solid black 1.0pt;border-top: none;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">No</span></b></p>
                  </td><td width="66%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Anomalie</span></b></p>
                  </td><td width="27%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Observations du comptable</span></b></p>
                  </td></tr>
            </thead><xsl:variable name="varOdm2" select="$varOdm1"/><xsl:variable name="varOdm3"><xsl:for-each select="$varOdm2"><xsl:sort select="./NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr><td width="7%" valign="top" style="border:solid black 1.0pt; border-top:none;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/NumRegle)"/></span></p></td><td width="66%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/LibelleAnomalie)"/></span></p><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/ComplementAnomalie)"/></span></p></td><td width="27%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 5.4pt 0cm 5.4pt;height:7.1pt" rowspan="1" colspan="1"> </td></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm4"><xsl:choose><xsl:when test="count($varOdm3/*) = 0"><tr class=" #tech#" style="height:7.15pt"><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt; border-bottom:solid black 1.0pt; border-left:solid black 1.0pt; border-right:solid black 1.0pt"></td><td height="1px" width="66%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="27%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm3"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowBorders"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm4/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <xsl:for-each select="$docbudg[(./EnteteComptable/Infos/Nomenclature/@V='M21')]/BudgetCCA[(./@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]"><xsl:sort select="."></xsl:sort><xsl:variable name="codeBoucleTable" select="."></xsl:variable><xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid PAGE_BREAK" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm5" select="$codeBoucleTable/Anomalie"/><thead>
               <tr><xsl:variable name="varOdm6" select="$varOdm5"/><td width="100%" colspan="3" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                     <p class="MsoNormal"></p>
                  </td></tr>
               <tr><td width="75%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@PlanCpte)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Population : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/EnteteComptable/Infos/Collectivite/@Population"/><xsl:with-param name="format" select="&quot;# ##0&quot;"/></xsl:call-template></span></p></td></tr>
               <tr><xsl:variable name="varOdm7" select="$varOdm5"/><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><xsl:for-each select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M21')]/BudgetAnnexe/@IdNat"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3" select="."></xsl:variable><xsl:variable name="blocLignes_DCCA_ETT_BA_IdNatTxt_3" select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M21')]/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3)]"/><xsl:if test="$blocLignes_DCCA_ETT_BA_IdNatTxt_3"><p align="right" style="text-align:right"><span style="color:black"><xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_3/@IdNat">Type de Budget :</xsl:if> <xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_3/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3)]/@TypeBC)"/></xsl:if></span></p></xsl:if></xsl:for-each></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Type de collectivité : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeColl)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Édition : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@TypeEdition)"/></span></p></td></tr>
               <tr><td width="100%" colspan="3" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><xsl:for-each select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M21')]/BudgetAnnexe/@IdNat"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1" select="."></xsl:variable><xsl:variable name="blocLignes_DCCA_ETT_BA_IdNatTxt_1" select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M21')]/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]"/><xsl:if test="$blocLignes_DCCA_ETT_BA_IdNatTxt_1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black"><xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_1/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]/@CodeBC)"/></xsl:if> <xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_1/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]/@Libelle)"/></xsl:if></span></b></p></xsl:if></xsl:for-each></td></tr>
               <tr><td width="100%" colspan="3" valign="top" style="border:none; border-bottom:solid black 1.0pt;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">État d’anomalies des contrôles comptables</span></b></p><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">Arrêté à la date du : <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p><p align="right" style="text-align:right"> </p></td></tr>
               <tr style="height:7.15pt"><td width="7%" style="border:solid black 1.0pt;border-top: none;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">No</span></b></p>
                  </td><td width="66%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Anomalie</span></b></p>
                  </td><td width="27%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Observations du comptable</span></b></p>
                  </td></tr>
            </thead><xsl:variable name="varOdm8" select="$varOdm5"/><xsl:variable name="varOdm9"><xsl:for-each select="$varOdm8"><xsl:sort select="./NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr><td width="7%" valign="top" style="border:solid black 1.0pt; border-top:none;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/NumRegle)"/></span></p></td><td width="66%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/LibelleAnomalie)"/></span></p><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/ComplementAnomalie)"/></span></p></td><td width="27%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 5.4pt 0cm 5.4pt;height:7.1pt" rowspan="1" colspan="1"> </td></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm10"><xsl:choose><xsl:when test="count($varOdm9/*) = 0"><tr class=" #tech#" style="height:7.15pt"><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt; border-bottom:solid black 1.0pt; border-left:solid black 1.0pt; border-right:solid black 1.0pt"></td><td height="1px" width="66%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="27%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm9"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowBorders"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm10/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template></xsl:for-each>
         <p class="MsoNormal"> </p>
         <xsl:for-each select="$docbudg[(./EnteteComptable/Infos/Nomenclature/@V='M22')]/BudgetCCA[(./@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]"><xsl:sort select="."></xsl:sort><xsl:variable name="codeBoucleTable" select="."></xsl:variable><xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid PAGE_BREAK" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm11" select="$codeBoucleTable/Anomalie"/><thead>
               <tr><xsl:variable name="varOdm12" select="$varOdm11"/><td width="100%" colspan="3" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                     <p class="MsoNormal"></p>
                  </td></tr>
               <tr><td width="75%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@PlanCpte)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Population : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/EnteteComptable/Infos/Collectivite/@Population"/><xsl:with-param name="format" select="&quot;# ##0&quot;"/></xsl:call-template></span></p></td></tr>
               <tr><xsl:variable name="varOdm13" select="$varOdm11"/><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><xsl:for-each select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22')]/BudgetAnnexe/@IdNat"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3" select="."></xsl:variable><xsl:variable name="blocLignes_DCCA_ETT_BA_IdNatTxt_3" select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22')]/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3)]"/><xsl:if test="$blocLignes_DCCA_ETT_BA_IdNatTxt_3"><p align="right" style="text-align:right"><span style="color:black"><xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_3/@IdNat">Type de Budget :</xsl:if> <xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_3/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3)]/@TypeBC)"/></xsl:if></span></p></xsl:if></xsl:for-each></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Type de collectivité : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeColl)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Édition : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@TypeEdition)"/></span></p></td></tr>
               <tr><td width="100%" colspan="3" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><xsl:for-each select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22')]/BudgetAnnexe/@IdNat"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1" select="."></xsl:variable><xsl:variable name="blocLignes_DCCA_ETT_BA_IdNatTxt_1" select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22')]/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]"/><xsl:if test="$blocLignes_DCCA_ETT_BA_IdNatTxt_1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black"><xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_1/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]/@CodeBC)"/></xsl:if> <xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_1/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]/@Libelle)"/></xsl:if></span></b></p></xsl:if></xsl:for-each></td></tr>
               <tr><td width="100%" colspan="3" valign="top" style="border:none; border-bottom:solid black 1.0pt;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">État d’anomalies des contrôles comptables</span></b></p><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">Arrêté à la date du : <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p><p align="right" style="text-align:right"> </p></td></tr>
               <tr style="height:7.15pt"><td width="7%" style="border:solid black 1.0pt;border-top: none;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">No</span></b></p>
                  </td><td width="66%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Anomalie</span></b></p>
                  </td><td width="27%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Observations du comptable</span></b></p>
                  </td></tr>
            </thead><xsl:variable name="varOdm14" select="$varOdm11"/><xsl:variable name="varOdm15"><xsl:for-each select="$varOdm14"><xsl:sort select="./NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr><td width="7%" valign="top" style="border:solid black 1.0pt; border-top:none;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/NumRegle)"/></span></p></td><td width="66%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/LibelleAnomalie)"/></span></p><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/ComplementAnomalie)"/></span></p></td><td width="27%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 5.4pt 0cm 5.4pt;height:7.1pt" rowspan="1" colspan="1"> </td></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm16"><xsl:choose><xsl:when test="count($varOdm15/*) = 0"><tr class=" #tech#" style="height:7.15pt"><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt; border-bottom:solid black 1.0pt; border-left:solid black 1.0pt; border-right:solid black 1.0pt"></td><td height="1px" width="66%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="27%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm15"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowBorders"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm16/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template></xsl:for-each>
         <p class="MsoNormal"> </p>
         <xsl:for-each select="$docbudg[(./EnteteComptable/Infos/Nomenclature/@V='M22_EPRD')]/BudgetCCA[(./@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]"><xsl:sort select="."></xsl:sort><xsl:variable name="codeBoucleTable" select="."></xsl:variable><xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid PAGE_BREAK" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm17" select="$codeBoucleTable/Anomalie"/><thead>
               <tr><xsl:variable name="varOdm18" select="$varOdm17"/><td width="100%" colspan="3" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                     <p class="MsoNormal"></p>
                  </td></tr>
               <tr><td width="75%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@PlanCpte)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Population : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/EnteteComptable/Infos/Collectivite/@Population"/><xsl:with-param name="format" select="&quot;# ##0&quot;"/></xsl:call-template></span></p></td></tr>
               <tr><xsl:variable name="varOdm19" select="$varOdm17"/><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><xsl:for-each select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22_EPRD')]/BudgetAnnexe/@IdNat"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3" select="."></xsl:variable><xsl:variable name="blocLignes_DCCA_ETT_BA_IdNatTxt_3" select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22_EPRD')]/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3)]"/><xsl:if test="$blocLignes_DCCA_ETT_BA_IdNatTxt_3"><p align="right" style="text-align:right"><span style="color:black"><xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_3/@IdNat">Type de Budget :</xsl:if> <xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_3/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_3)]/@TypeBC)"/></xsl:if></span></p></xsl:if></xsl:for-each></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Type de collectivité : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeColl)"/></span></p></td></tr>
               <tr><td width="75%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="color:black">Édition : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@TypeEdition)"/></span></p></td></tr>
               <tr><td width="100%" colspan="3" valign="top" style=" padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><xsl:for-each select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22_EPRD')]/BudgetAnnexe/@IdNat"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1" select="."></xsl:variable><xsl:variable name="blocLignes_DCCA_ETT_BA_IdNatTxt_1" select="$docbudg[(./BudgetCCA=$codeBoucleTable) and (./BudgetCCA/@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]/EnteteComptable/Infos[(./Nomenclature/@V='M22_EPRD')]/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]"/><xsl:if test="$blocLignes_DCCA_ETT_BA_IdNatTxt_1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black"><xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_1/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]/@CodeBC)"/></xsl:if> <xsl:if test="$codeBoucleTable/@IdNat = $blocLignes_DCCA_ETT_BA_IdNatTxt_1/@IdNat"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe[(./@IdNat=$codeBoucleBloc_DCCA_ETT_BA_IdNatTxt_1)]/@Libelle)"/></xsl:if></span></b></p></xsl:if></xsl:for-each></td></tr>
               <tr><td width="100%" colspan="3" valign="top" style="border:none; border-bottom:solid black 1.0pt;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">État d’anomalies des contrôles comptables</span></b></p><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;color:black">Arrêté à la date du : <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p><p align="right" style="text-align:right"> </p></td></tr>
               <tr style="height:7.15pt"><td width="7%" style="border:solid black 1.0pt;border-top: none;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">No</span></b></p>
                  </td><td width="66%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Anomalie</span></b></p>
                  </td><td width="27%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.15pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="color:black">Observations du comptable</span></b></p>
                  </td></tr>
            </thead><xsl:variable name="varOdm20" select="$varOdm17"/><xsl:variable name="varOdm21"><xsl:for-each select="$varOdm20"><xsl:sort select="./NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr><td width="7%" valign="top" style="border:solid black 1.0pt; border-top:none;padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"> <xsl:value-of select="distinct-values($ligne/NumRegle)"/></span></p></td><td width="66%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:7.1pt" rowspan="1" colspan="1"><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/LibelleAnomalie)"/></span></p><p><span style="font-size:9.0pt;color:black"><xsl:value-of select="distinct-values($ligne/ComplementAnomalie)"/></span></p></td><td width="27%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 5.4pt 0cm 5.4pt;height:7.1pt" rowspan="1" colspan="1"> </td></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm22"><xsl:choose><xsl:when test="count($varOdm21/*) = 0"><tr class=" #tech#" style="height:7.15pt"><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt; border-bottom:solid black 1.0pt; border-left:solid black 1.0pt; border-right:solid black 1.0pt"></td><td height="1px" width="66%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="27%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#7F7F7F;padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm21"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowBorders"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm22/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template></xsl:for-each>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>